/*Probador de servos para Attiny85 y Attiny45 usando Arduino como programador.
 * Código escrito por Joyvel Osorio basándose en otros ejemplos conseguidos en internet
 * de forma libre y gratuita, este código necesita la librería SoftwareServo para funcionar. Tutorial y más 
 * información detallada se puede encontrar en los siguientes enlaces: Artículo http://joyplanes.com/probador-de-servos-diy/
 * y el video https://youtu.be/x_0zDgfckFo
 */

#include <SoftwareServo.h>

SoftwareServo myservo;
int pos = 90;    // variable para guardar la posición del servo
int pot = 1; //ADC1 NO PB1 Puerto de salida para servo

//boton
const int  buttonPin = 3;    // Pin para el botón

// Variables cambiantes:
int buttonPushCounter = 0;   // contador para las veces que se presiona el botón
int buttonState = 0;         // estado actual del botón
int lastButtonState = 0;     // estado previo del botón



void setup() {
  myservo.attach(0);
  myservo.setMinimumPulse(950);
  myservo.setMaximumPulse(2100);
  myservo.write(90);
  delay(20);
  SoftwareServo::refresh();
  // initialize the button pin as a input:
  pinMode(buttonPin, INPUT);
}

void loop() {
     // pin de entrada para el botón:
  buttonState = digitalRead(buttonPin);

  // comparar el estado del botón al previo
  if (buttonState != lastButtonState) {
    // if the state has changed, increment the counter
    if (buttonState == HIGH) {
      // si el estado actual es HIGH entonces fue de off a on:
      buttonPushCounter++;
    } 
    // Delay para evitar rebote
    delay(50);
  }

  lastButtonState = buttonState;


  
  // comportamientos o modos
  if (buttonPushCounter == 0) {
    
    int valor = analogRead(pot);
    valor = map(valor,0,1023,0,179);
    pos = valor;
    myservo.write(pos);
    delay(2);
    SoftwareServo::refresh();
  }


  if (buttonPushCounter == 1){
    pos = 90;
    myservo.write(pos);
    delay(2);
    SoftwareServo::refresh();
  }

  if (buttonPushCounter == 2){
    for(pos = 0; pos < 180; pos += 1)  // va de 0 a 180 grados
  {                                  // en pasos de 1 grado 
    myservo.write(pos);              // le dice al servo donde ir según la variable 'pos' 
    delay(9);                       // espera unos milisegundos para alcanzar esa posición.
    SoftwareServo::refresh();

          //Chequea el botón de nuevo
          buttonState = digitalRead(buttonPin);

          // compare the buttonState to its previous state
          if (buttonState != lastButtonState) {
            // if the state has changed, increment the counter
            if (buttonState == HIGH) {
              // if the current state is HIGH then the button went from off to on:
              buttonPushCounter++;
            } 
            // Delay a little bit to avoid bouncing
            delay(20);
          }
        
          lastButtonState = buttonState;
          if (buttonPushCounter >= 3) {
          buttonPushCounter = 0;
            }
            
          } 
  for(pos = 180; pos>=1; pos-=1)     // va de 180 a 0 grados 
  {                                
    myservo.write(pos);            
    delay(9);                       
    SoftwareServo::refresh();

              //Chequea botón de nuevo
          buttonState = digitalRead(buttonPin);

          
          if (buttonState != lastButtonState) {
            
            if (buttonState == HIGH) {
              
              buttonPushCounter++;
            } 
            
            delay(20);
          }
        
          lastButtonState = buttonState;
          if (buttonPushCounter >= 3) {
          buttonPushCounter = 0;
              }
            
          }
    }
   
  

}
